class ShoppingCart

  def self.find_or_create_with token
    if token.nil?
      loop do
        token = "#{SecureRandom.urlsafe_base64}"
        break if Cart.find_by_cookie_key(token) == nil
      end
    end

    ShoppingCart.new token
  end

  def initialize(cart_key)
    # Find or create cart and store it in memory
    @cart = Cart.find_by_cookie_key(cart_key)

    if @cart.nil?
      @cart = create_cart(cart_key)
    else
      if @cart.updated_at < 15.minutes.ago
        Rails.logger.debug "Shopping cart is getting old"
        @cart.delete
        @cart = create_cart(cart_key)
      else
        age = Time.now - @cart.updated_at
        Rails.logger.debug "Cart still OK. age: #{age}"
        @cart.touch # update time stamp
      end
    end

    @cart
  end

  def create_cart(cookie_key)
    Cart.create(:cookie_key => cookie_key)
  end

  def add(product_id)
    cart_item = CartItem.new(:product_price => 10, :product_id => product_id, :product_name => 'Test Product')
    @cart.cart_items <<= cart_item

    cart_item.save
  end

  def token
    return nil if @cart.nil?
    @cart.cookie_key
  end

  def as_json
    response = {
      item_count: @cart.cart_items.size
    }

    if @cart.cart_items.size > 0
      response[:items] = @cart.cart_items
    else
      response[:items] = []
    end

    response.as_json
  end

end